#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef pair<int, int> point;

const int MAX_N = 200001;
point a[MAX_N], lc[MAX_N], uc[MAX_N];
set<point> orig;
int n;

bool left(const point &o, const point &a, const point &b) {
  return (a.first - o.first + 0LL)*(b.second - o.second)
       - (a.second - o.second + 0LL)*(b.first - o.first) <= 0;
}

int count(int x) {
  if (orig.find(a[x]) == orig.end()) {
    return orig.size();
  }
  int k = 0;
  for (int i = 0; i < n; i++) {
    if (i == x) continue;
    while (k >= 2 && left(lc[k-2], lc[k-1], a[i])) k--;
    lc[k++] = a[i];
  }
  int l = 0;
  for (int i = n-1; i >= 0; i--) {
    if (i == x) continue;
    while (l >= 2 && left(uc[l-2], uc[l-1], a[i])) l--;
    uc[l++] = a[i];
  }
  return k + l - 2;
}

int setup() {
  int k = 0;
  for (int i = 0; i < n; i++) {
    while (k >= 2 && left(lc[k-2], lc[k-1], a[i])) k--;
    lc[k++] = a[i];
  }
  for (int i = 0; i < k; i++) {
    orig.insert(lc[i]);
  }
  int l = 0;
  for (int i = n-1; i >= 0; i--) {
    while (l >= 2 && left(uc[l-2], uc[l-1], a[i])) l--;
    uc[l++] = a[i];
  }
  for (int i = 0; i < l; i++) {
    orig.insert(uc[i]);
  }
}

ll gcd(ll a, ll b) {
  while (b > 0) {
    a %= b;
    swap(a, b);
  }
  return a;
}

int main() {
  ios::sync_with_stdio(false); cin.tie(0);
  cin >> n;
  for (int i = 0; i < n; i++) {
    cin >> a[i].first >> a[i].second;
  }
  sort(a, a + n);
  setup();
  ll ans = 0;
  for (int i = 0; i < n; i++) {
    ans += count(i);
  }
  ll gd = gcd(ans, n);
  cout << (ans / gd) << " " << (n / gd) << endl;
  return 0;
}
